<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    
    <title>Billing</title>

    <!-- Required Styles -->
    <link href="../assets/css/bootstrap.min.css" rel="stylesheet" />
    <link href="../assets/css/style.css" rel="stylesheet" />
    <link href="../assets/css/soft-ui-dashboard.css?v=1" rel="stylesheet" />
    <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700" rel="stylesheet" />

    <!-- SweetAlert -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>

<body class="mt-5" style="background-color: rgb(217, 236, 255)">
    <div class="container">
        <div class="card">
            <div class="card-header">
                <h4>Settings</h4>
            </div>
            <form action="<?php echo e(route('settings_save')); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-4">
                            <label for="super_admin_name">Super Admin Name</label>
                            <input type="text" name="super_admin_name" id="super_admin_name" class="form-control"
                                placeholder="Enter a name">
                        </div>
                        <div class="col-lg-4">
                            <label for="email">Email</label>
                            <input type="email" name="email" id="email" class="form-control"
                                placeholder="Enter an Email">
                        </div>
                        <div class="col-lg-4">
                            <label for="company">Company</label>
                            <input name="company" id="company" class="form-control" placeholder="Enter Company Name">
                        </div>
                        <div class="col-lg-4">
                            <label for="branch">Branch</label>
                            <input name="branch" id="branch" class="form-control" placeholder="Enter Branch Name">
                        </div>
                        <div class="col-lg-4">
                            <label for="phone">Phone</label>
                            <input type="text" name="phone" id="phone" class="form-control"
                                placeholder="Enter a Phone Number">
                        </div>
                        <div class="col-lg-4">
                            <label for="password">Password</label>
                            <input type="password" name="password" id="password" class="form-control"
                                placeholder="Enter a Password">
                        </div>
                    </div>
                </div>
                <div class="card-footer p-4 text-end">
                    <button type="submit" class="btn btn-primary">Save</button>
                </div>
            </form>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
        $(document).ready(function () {
            <?php if(session('success')): ?>
                Swal.fire({
                    icon: 'success',
                    title: 'Success!',
                    text: '<?php echo e(session('success')); ?>',
                    confirmButtonColor: '#3085d6',
                    confirmButtonText: 'OK'
                });
            <?php endif; ?>

            <?php if(session('error')): ?>
                Swal.fire({
                    icon: 'error',
                    title: 'Error!',
                    text: '<?php echo e(session('error')); ?>',
                    confirmButtonColor: '#d33',
                    confirmButtonText: 'OK'
                });
            <?php endif; ?>
        });
    </script>
</body>

</html>
<?php /**PATH /opt/lampp/htdocs/lara_commonbilling_new/resources/views/settings/settings.blade.php ENDPATH**/ ?>