<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TempQuantityModel extends Model
{
    use HasFactory;

    protected $table = 'temp_quantities';

    protected $fillable = [
        'product_id',
        'branch_id', 
        'temp_qty'
    ];

    protected $casts = [
        'temp_qty' => 'integer',
    ];

    // Relationships
    public function product()
    {
        return $this->belongsTo(ProductModel::class, 'product_id');
    }

    public function branch()
    {
        return $this->belongsTo(BranchModel::class, 'branch_id');
    }
}
